/**
 * @author       Laurent Jouanneau
 * @copyright    2007-2020 Laurent Jouanneau
 * @link         https://jelix.org
 * @licence      GNU Lesser General Public Licence see LICENCE file or http://www.gnu.org/licenses/lgpl.html
 */

import jFormsJQ from './jFormsJQ.js';
/**
 * control with HTML content generated by a wysiwyg editor
 */
export default function jFormsJQControlHtml(name, label) {
    this.name = name;
    this.label = label;
    this.required = false;
    this.errInvalid = '';
    this.errRequired = '';
    this.minLength = -1;
    this.maxLength = -1;
    this.readOnly = false;
}

jFormsJQControlHtml.prototype.check = function (val, jfrm) {
    if(this.minLength != -1 && val.length < this.minLength)
        return false;
    if(this.maxLength != -1 && val.length > this.maxLength)
        return false;
    return true;
};
jFormsJQControlHtml.prototype.getValue = function () {
    var frm = jFormsJQ.getForm(this.formName);
    var elt = frm.element.elements[this.name];
    if (!elt) return null;
    var val = jFormsJQ.getValue(elt);
    if (val == null)
        return null;
    val = val.replace(/<(img|object|video|svg|embed)[^>]*>/gi, 'TAG'); //tags which are contents
    val = val.replace(/<\/?[\S][^>]*>/gi, '');
    val = val.replace(/&[a-z]+;/gi, '');
    val = $.trim(val);
    if (val =='')
        return null;
    return val;
};

